/* eslint-disable no-console */
/* eslint-disable no-plusplus */
/* eslint-disable prefer-destructuring */
/* eslint-disable no-else-return */
/* eslint-disable no-restricted-syntax */
/* eslint-disable guard-for-in */
/* eslint-disable no-undef */
/* eslint-disable no-unused-vars */


// ------------------------------------------------------------- Tools


function htmlEncode(source, display, tabs) {
    function special(src) {
        let result = '';
        for (let i = 0; i < src.length; i += 1) {
            let c = src.charAt(i);
            if (c < ' ' || c > '~') {
                c = `&#${c.charCodeAt()};`;
            }
            result += c;
        }
        return result;
    }

    function format(src) {
        // Use only integer part of tabs, and default to 4
        const tabs1 = (tabs >= 0) ? Math.floor(tabs) : 4;

        // split along line breaks
        const lines = src.split(/\r\n|\r|\n/);

        // expand tabs
        for (let i = 0; i < lines.length; i += 1) {
            const line = lines[i];
            let newLine = '';
            for (let p = 0; p < line.length; p += 1) {
                const c = line.charAt(p);
                if (c === '\t') {
                    const spaces = tabs1 - (newLine.length % tabs1);
                    for (let s = 0; s < spaces; s += 1) {
                        newLine += ' ';
                    }
                }
                else {
                    newLine += c;
                }
            }
            // If a line starts or ends with a space, it evaporates in html
            // unless it's an nbsp.
            newLine = newLine.replace(/(^ )|( $)/g, '&nbsp;');
            lines[i] = newLine;
        }

        // re-join lines
        let result = lines.join('<br />');

        // break up contiguous blocks of spaces with non-breaking spaces
        result = result.replace(/ {2}/g, ' &nbsp;');

        // tada!
        return result;
    }

    let result = source;

    // ampersands (&)
    result = result.replace(/&/g, '&amp;');

    // less-thans (<)
    result = result.replace(/</g, '&lt;');

    // greater-thans (>)
    result = result.replace(/>/g, '&gt;');

    if (display) {
        // format for display
        result = format(result);
    }
    else {
        // Replace quotes if it isn't for display,
        // since it's probably going in an html attribute.
        result = result.replace(new RegExp('"', 'g'), '&quot;');
    }

    // special characters
    result = special(result);

    // tada!
    return result;
};



// ------------------------------------------------------------- REST

class RestError extends Error {
	constructor(message, status, statusText, errorStack, errCode) {
		super(message);
		this.status = status;
		this.statusText = statusText;
		this.errorStack = errorStack;
		this.errCode = errCode;
	}

	getDescription() {
		let result = '';
		if (this.message != null) result += this.message;
		if (this.status != null) result += `, status code: ${this.status}`;
		if (this.statusText != null) result += `, ${this.statusText}`;
		return result;
	}
}

async function restRequest(command, url, body) {
	if (!body) body = null;
	if (body != null) {
		if (body instanceof Object) body = JSON.stringify(body);
	}

	const settings = {
		method: command,
		body: body,
	};

	return new Promise(async (resolve, reject) => {
		const ev = new Event('datasource:error');
		try {
			const response = await fetch(url, settings);
			let resp = null;
			let respIsObject = false;
			try {
				resp = await response.json();
				respIsObject = true;
			} catch (err) {
				resp = await response.text();
			}
			if (response.status == 200) {
				resolve(resp);
			} else {
				let alreadyReject = false;
				if (respIsObject) {
					const obj = resp;
					if (obj != null && obj.__ERROR != null) {
						if (obj.__ERROR.length > 0) {
							alreadyReject = true;

							const err = new RestError(obj.__ERROR[0].message, response.status, response.statusText, obj.__ERROR, obj.__ERROR[0].errCode);
							ev.error = err;
							window.dispatchEvent(ev);
							reject(err);
						}
					}
				}
				if (!alreadyReject) {
					const err = new RestError('Rest Error', response.status, response.statusText, null, null);
					ev.error = err;
					window.dispatchEvent(ev);
					reject(err);
				}
			}
		} catch (e) {
			const err = new RestError('Network Error', -1, '', [{ errCode: -2, nativeError: e }], null);
			ev.error = err;
			window.dispatchEvent(ev);
			reject(err);
		}
	});
}

async function oldrestRequest(command, url, body) {
	if (!body) body = null;
	if (body != null) {
		if (body instanceof Object) body = JSON.stringify(body);
	}
	return new Promise((resolve, reject) => {
		const req = new XMLHttpRequest();
		req.open(command, url);

		req.onload = () => {
			if (req.status === 200) {
				let resp = req.responseText;
				try {
					const respobj = JSON.parse(req.responseText);
					resp = respobj;
				} catch (err) {
					// Do nothing
				}
				resolve(resp);
			} else {
				let alreadyReject = false;
				try {
					const obj = JSON.parse(req.responseText);
					if (obj != null && obj.__ERROR != null) {
						if (obj.__ERROR.length > 0) {
							alreadyReject = true;
							reject(new RestError(obj.__ERROR[0].message, req.status, req.statusText, obj.__ERROR, obj.__ERROR[0].errCode));
						}
					}
				} catch (err) {
					// Do nothing
				}

				if (!alreadyReject) reject(new RestError('Rest Error', req.status, req.statusText, null, null));
			}
		};

		req.onerror = function reqOnerr(err) {
			reject(new RestError('Network Error', -1, '', [{ errCode: -2, nativeError: err }], null));
		};
		req.send(body);
	});
}

// ------------------------------------------------------------- Metrics


class MetricsManager {
    constructor($div) {
        this.$maindiv = $div;
        this.$maindiv.on('click', '.clientRow', this.handleClickClientRow.bind(this));
        this.$maindiv.on('click', '.processRow', this.handleClickProcessRow.bind(this));
        this.$maindiv.on('click', '.sortable', this.handleClickSortCol.bind(this));
        $('#refresh').on('click', this.handleRefresh.bind(this));

        this.updateMetrics();
        
        this.settings = {
            sorting: {
                clients: "byName",
                processes: "byName",
                methods: "byName"
            }
        };
        
    }

    handleRefresh(event) {
        this.updateMetrics(true);
    }

    getSortingSettings(whichpart) {
        const result = {
            byName: false,
            byEntitySel: false,
            bySel: false,
            byBittable: false
        };
        const setting = this.settings.sorting[whichpart];
        if (setting === 'bySel')
            result.bySel = true;
        else if (setting === 'byEntitySel')
            result.byEntitySel = true;
        else if (setting === 'byBittable')
            result.byBittable = true;
        else
            result.byName = true;
        return result;
    }

    getMetricName(e, metric) {
        let result = e;
        const clientinfo = metric.clientInfo;
        if (clientinfo != null) {
            result = clientinfo.host_name + ' (' + clientinfo.host_ip + ')';
        }
        return result;
    }

    sortElems(elems, settings) {
        const manager = this;
        if (settings.byName) {
            elems.sort(([e1, metric1], [e2, metric2]) => {
                const s1 = manager.getMetricName(e1, metric1);
                const s2 = manager.getMetricName(e2, metric2);
                return s1.localeCompare(s2);
            });
        } else if (settings.byEntitySel) {
            elems.sort(([e1, metric1], [e2, metric2]) => {
                const x1 = metric1.total == null ? metric1.entitySelections : metric1.total.entitySelections;
                const x2 = metric2.total == null ? metric2.entitySelections : metric2.total.entitySelections;
                return x1 === x2 ? 0 : (x1 < x2 ?  1 : -1);
            });
        } else if (settings.bySel) {
            elems.sort(([e1, metric1], [e2, metric2]) => {
                const x1 = metric1.total == null ? metric1.selections : metric1.total.selections;
                const x2 = metric2.total == null ? metric2.selections : metric2.total.selections;
                return x1 === x2 ? 0 : (x1 < x2 ?  1 : -1);
            });
        } else if (settings.byBittable) {
            elems.sort(([e1, metric1], [e2, metric2]) => {
                const x1 = metric1.total == null ? metric1.bittables : metric1.total.bittables;
                const x2 = metric2.total == null ? metric2.bittables : metric2.total.bittables;
                return x1 === x2 ? 0 : (x1 < x2 ?  1 : -1);
            });
        }
        
    }

    
    async getMetrics() {
        try {
            const metrics = await restRequest('get', '/rest/$metrics');
            this.metrics = metrics;
        }
        catch (err) {
            this.metrics = null;
            this.metricsErr = err;
        }
    }

    async updateMetrics(full = true) {
        if (full) {
            await this.getMetrics();
        }
        if (this.metrics != null) {
            const $clientdiv = this.$maindiv.find('.byClient .metricsContent');
            let html = '';
            const clientsmetrics = Object.entries(this.metrics.clients);
            
            let sortSettings = this.getSortingSettings('clients');
            this.sortElems(clientsmetrics, sortSettings);
            
            
            clientsmetrics.forEach(([e, metric]) => {
                html += '<div class="metricsRowHolder">';
                html += `<div class="metricsRow clientRow" data-clientID="${e}">`;
                const name = this.getMetricName(e, metric);
                html += `<div class="metricsCol first">${htmlEncode(name)}</div>`;
                html += `<div class="metricsCol">${metric.total.entitySelections}</div>`;
                html += `<div class="metricsCol">${metric.total.selections}</div>`;
                html += `<div class="metricsCol">${metric.total.bittables}</div>`;
                html += '</div>';
                if (metric.expanded) {
                    const subhtml = this.generateProcessReport(metric.processes, e);
                    html += subhtml;
                }
                html += '</div>';
            });
            $clientdiv.html(html);

            const $processdiv = this.$maindiv.find('.byProcess .metricsContent');
            html = this.generateProcessReport(this.metrics.processes);
            $processdiv.html(html);

            const $methodsdiv = this.$maindiv.find('.byMethod .metricsContent');
            const methodsmetrics = Object.entries(this.metrics.methods);
            html = this.generateMethodReport(methodsmetrics, false);
            $methodsdiv.html(html);
        }
    }

    handleClickSortCol(event) {
        const ref = event.currentTarget.getAttribute('data-ref');
        const order = event.currentTarget.getAttribute('data-order');
        this.settings.sorting[ref] = order;
        this.updateMetrics(false);
    }

    generateProcessReport(processes, clientID = null) {
        const processmetrics = Object.entries(processes);
        const sortSettings = this.getSortingSettings('processes');
        this.sortElems(processmetrics, sortSettings);
        let html = '';
        if (clientID != null) {
            html += '<div class="metricsSubPart">';
            html += '<div class="metricsTitleRow">';
            html += '<div class="metricsTitleCol first">Process Name</div>';
            html += '<div class="metricsTitleCol">Entity Selections</div>';
            html += '<div class="metricsTitleCol">Selections</div>';
            html += '<div class="metricsTitleCol">Bit Tables</div>';
            html += '</div>';
        }

        processmetrics.forEach(([e, metric]) => {
            html += '<div class="metricsRowHolder">';
            if (clientID == null)
                html += `<div class="metricsRow processRow" data-processID="${e}">`;
            else
                html += `<div class="metricsRow processRow" data-processID="${e}" data-clientID="${clientID}">`;
            html += `<div class="metricsCol first">${htmlEncode(e)}</div>`;
            html += `<div class="metricsCol">${metric.total.entitySelections}</div>`;
            html += `<div class="metricsCol">${metric.total.selections}</div>`;
            html += `<div class="metricsCol">${metric.total.bittables}</div>`;
            html += '</div>';
            if (metric.expanded) {
                const subhtml = this.generateMethodReport(Object.entries(metric.methods), true);
                html += subhtml;
            }
            html += '</div>';
        });

        if (clientID != null) {
            html += '</div>';
        }
        return html;
    }
    
    generateMethodReport(methodMetrics, withHeaders = false) {
        const sortSettings = this.getSortingSettings('methods');
        this.sortElems(methodMetrics, sortSettings);
        let html = '';

        if (withHeaders) {
            html += '<div class="metricsSubPart">';
            html += '<div class="metricsTitleRow">';
            html += '<div class="metricsTitleCol first">Method Name</div>';
            html += '<div class="metricsTitleCol">Entity Selections</div>';
            html += '<div class="metricsTitleCol">Selections</div>';
            html += '<div class="metricsTitleCol">Bit Tables</div>';
            html += '</div>';
        }
    
        methodMetrics.forEach(([e, metric]) => {
            //html += '<div class="metricsRowHolder">';
            html += '<div class="metricsRow methodRow">';
            html += `<div class="metricsCol first">${htmlEncode(e)}</div>`;
            html += `<div class="metricsCol">${metric.entitySelections}</div>`;
            html += `<div class="metricsCol">${metric.selections}</div>`;
            html += `<div class="metricsCol">${metric.bittables}</div>`;
            html += '</div>';
            //html += '</div>';
        });

        if (withHeaders) {
            html += '</div>';
        }

        return html;
    }


    handleClickClientRow(event) {
        const $div = $(event.currentTarget).parent();
        const built = event.currentTarget.getAttribute('data-built');
        const id = event.currentTarget.getAttribute('data-clientID');
        const clientmetrics = this.metrics.clients[id];
        if (built == null) {
            event.currentTarget.setAttribute('data-built', 'expanded');
            const html = this.generateProcessReport(clientmetrics.processes, id);
            $div.append(html);
            clientmetrics.expanded = true;
        } else {
            if (built == 'expanded') {
                event.currentTarget.setAttribute('data-built', 'collapsed');
                $div.find('.metricsSubPart').addClass('hidden');
                clientmetrics.expanded = false;
            } else {
                event.currentTarget.setAttribute('data-built', 'expanded');
                $div.find('.metricsSubPart').removeClass('hidden');
                clientmetrics.expanded = true;
            }
        }
    }


    handleClickProcessRow(event) {
        const $div = $(event.currentTarget).parent();
        const built = event.currentTarget.getAttribute('data-built');
        const id = event.currentTarget.getAttribute('data-clientID');
        const processid = event.currentTarget.getAttribute('data-processID');
        let methodMetrics;
        let processmetrics;
        if (id == null) {
            processmetrics = this.metrics.processes[processid];
            methodMetrics = Object.entries(processmetrics.methods);
        } else {
            const clientmetrics = this.metrics.clients[id];
            processmetrics = clientmetrics.processes[processid];
            methodMetrics = Object.entries(processmetrics.methods);
        }

        if (built == null) {
            event.currentTarget.setAttribute('data-built', 'expanded');
            const html = this.generateMethodReport(methodMetrics, true);
            $div.append(html);
            processmetrics.expanded = true;
        } else {
            if (built == 'expanded') {
                event.currentTarget.setAttribute('data-built', 'collapsed');
                $div.find('.metricsSubPart').addClass('hidden');
                processmetrics.expanded = false;
            } else {
                event.currentTarget.setAttribute('data-built', 'expanded');
                $div.find('.metricsSubPart').removeClass('hidden');
                processmetrics.expanded = true;
            }
        }
    }


}



// ------------------------------------------------------------- main


window.addEventListener('load', () => {
    const metricManager = new MetricsManager($('.metrics'));
});
